"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, deletion_id: str = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a specific delete inventory operation.

    Args:
        deletion_id(str, optional): Specify the delete inventory ID for which you want information. This ID was returned by the DeleteInventory operation. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.inventory.deletion.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.inventory.deletion.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_inventory_deletions",
        op_kwargs={
            "DeletionId": deletion_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
