"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, instance_ids: List, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the high-level patch state of one or more instances.

    Args:
        instance_ids(List): The ID of the instance for which patch state information should be retrieved.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_results(int, optional): The maximum number of instances to return (per page). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.instance.patch.state.init.describe_all(
                ctx, instance_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.instance.patch.state.init.describe_all instance_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_instance_patch_states",
        op_kwargs={
            "InstanceIds": instance_ids,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
