"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    patch_group: str,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the high-level patch state for the instances in the specified patch group.

    Args:
        patch_group(str): The name of the patch group for which the patch state information should be retrieved.
        filters(List, optional): Each entry in the array is a structure containing:   Key (string between 1 and 200 characters)   Values (array containing a single string)   Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")  . Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_results(int, optional): The maximum number of patches to return (per page). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.instance.patch.state.for_patch_group.describe(
                ctx, patch_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.instance.patch.state.for_patch_group.describe patch_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_instance_patch_states_for_patch_group",
        op_kwargs={
            "PatchGroup": patch_group,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
