"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, instance_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    The status of the associations for the instance(s).

    Args:
        instance_id(str): The instance IDs for which you want association status information.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.instance.association_status.describe(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.instance.association_status.describe instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_instance_associations_status",
        op_kwargs={
            "InstanceId": instance_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
