"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, baseline_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Applies to patch baselines for Windows only.

    Args:
        baseline_id(str): The ID of the patch baseline to retrieve the effective patches for.
        max_results(int, optional): The maximum number of patches to return (per page). Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.effective.patch_for_patch_baseline.describe(
                ctx, baseline_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.effective.patch_for_patch_baseline.describe baseline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_effective_patches_for_patch_baseline",
        op_kwargs={
            "BaselineId": baseline_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
