"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    name: str,
    permission_type: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user's account ID) or publicly (All).

    Args:
        name(str): The name of the document for which you are the owner.
        permission_type(str): The permission type for the document. The permission type can be Share.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.permission.describe(
                ctx, name=value, permission_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.permission.describe name=value, permission_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_document_permission",
        op_kwargs={
            "Name": name,
            "PermissionType": permission_type,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def modify(
    hub,
    ctx,
    name: str,
    permission_type: str,
    account_ids_to_add: List = None,
    account_ids_to_remove: List = None,
    shared_document_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a document privately, you must specify the Amazon Web Services user account IDs for those people who can use the document. If you share a document publicly, you must specify All as the account ID.

    Args:
        name(str): The name of the document that you want to share.
        permission_type(str): The permission type for the document. The permission type can be Share.
        account_ids_to_add(List, optional): The Amazon Web Services user accounts that should have access to the document. The account IDs can either be a group of account IDs or All. Defaults to None.
        account_ids_to_remove(List, optional): The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services user account can either be a group of account IDs or All. This action has a higher priority than AccountIdsToAdd. If you specify an account ID to add and the same ID to remove, the system removes access to the document. Defaults to None.
        shared_document_version(str, optional): (Optional) The version of the document to share. If it isn't specified, the system choose the Default version to share. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.permission.modify(
                ctx, name=value, permission_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.permission.modify name=value, permission_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="modify_document_permission",
        op_kwargs={
            "Name": name,
            "PermissionType": permission_type,
            "AccountIdsToAdd": account_ids_to_add,
            "AccountIdsToRemove": account_ids_to_remove,
            "SharedDocumentVersion": shared_document_version,
        },
    )
