"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, name: str, document_reviews: Dict, document_version: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates information related to approval reviews for a specific version of a document.

    Args:
        name(str): The name of the document for which a version is to be updated.
        document_version(str, optional): The version of a document to update. Defaults to None.
        document_reviews(Dict): The document review details to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.metadata.init.update(
                ctx, name=value, document_reviews=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.metadata.init.update name=value, document_reviews=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_document_metadata",
        op_kwargs={
            "Name": name,
            "DocumentVersion": document_version,
            "DocumentReviews": document_reviews,
        },
    )
