"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    name: str,
    metadata: str,
    document_version: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Information about approval reviews for a version of an SSM document.

    Args:
        name(str): The name of the document.
        document_version(str, optional): The version of the document. Defaults to None.
        metadata(str): The type of data for which details are being requested. Currently, the only supported value is DocumentReviews.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.metadata.history.list(
                ctx, name=value, metadata=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.metadata.history.list name=value, metadata=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_document_metadata_history",
        op_kwargs={
            "Name": name,
            "DocumentVersion": document_version,
            "Metadata": metadata,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
