"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    content: str,
    name: str,
    requires: List = None,
    attachments: List = None,
    display_name: str = None,
    version_name: str = None,
    document_type: str = None,
    document_format: str = None,
    target_type: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems Manager performs on your managed instances. For more information about SSM documents, including information about supported schemas, features, and syntax, see Amazon Web Services Systems Manager Documents in the Amazon Web Services Systems Manager User Guide.

    Args:
        content(str): The content for the new SSM document in JSON or YAML format. We recommend storing the contents for your new document in an external JSON or YAML file and referencing the file in a command. For examples, see the following topics in the Amazon Web Services Systems Manager User Guide.    Create an SSM document (Amazon Web Services API)     Create an SSM document (Amazon Web Services CLI)     Create an SSM document (API)   .
        requires(List, optional): A list of SSM documents required by a document. This parameter is used exclusively by AppConfig. When a user creates an AppConfig configuration in an SSM document, the user must also specify a required document for validation purposes. In this case, an ApplicationConfiguration document requires an ApplicationConfigurationSchema document for validation purposes. For more information, see What is AppConfig? in the AppConfig User Guide. Defaults to None.
        attachments(List, optional): A list of key-value pairs that describe attachments to a version of a document. Defaults to None.
        name(str): A name for the SSM document.  You can't use the following strings as document name prefixes. These are reserved by Amazon Web Services for use as document name prefixes:    aws-     amazon     amzn    .
        display_name(str, optional): An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. You can update this value at a later time using the UpdateDocument operation. Defaults to None.
        version_name(str, optional): An optional field specifying the version of the artifact you are creating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed. Defaults to None.
        document_type(str, optional): The type of document to create. Defaults to None.
        document_format(str, optional): Specify the document format for the request. The document format can be JSON, YAML, or TEXT. JSON is the default format. Defaults to None.
        target_type(str, optional): Specify a target type to define the kinds of resources the document can run on. For example, to run a document on EC2 instances, specify the following value: /AWS::EC2::Instance. If you specify a value of '/' the document can run on all types of resources. If you don't specify a value, the document can't run on any resources. For a list of valid resource types, see Amazon Web Services resource and property types reference in the CloudFormation User Guide. . Defaults to None.
        tags(List, optional): Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an SSM document to identify the types of targets or the environment where it will run. In this case, you could specify the following key-value pairs:    Key=OS,Value=Windows     Key=Environment,Value=Production     To add tags to an existing SSM document, use the AddTagsToResource operation. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.init.create(ctx, content=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.init.create content=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_document",
        op_kwargs={
            "Content": content,
            "Requires": requires,
            "Attachments": attachments,
            "Name": name,
            "DisplayName": display_name,
            "VersionName": version_name,
            "DocumentType": document_type,
            "DocumentFormat": document_format,
            "TargetType": target_type,
            "Tags": tags,
        },
    )


async def delete(
    hub,
    ctx,
    name: str,
    document_version: str = None,
    version_name: str = None,
    force: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the Amazon Web Services Systems Manager document (SSM document) and all instance associations to the document. Before you delete the document, we recommend that you use DeleteAssociation to disassociate all instances that are associated with the document.

    Args:
        name(str): The name of the document.
        document_version(str, optional): The version of the document that you want to delete. If not provided, all versions of the document are deleted. Defaults to None.
        version_name(str, optional): The version name of the document that you want to delete. If not provided, all versions of the document are deleted. Defaults to None.
        force(bool, optional): Some SSM document types require that you specify a Force flag before you can delete the document. For example, you must specify a Force flag to delete a document of type ApplicationConfigurationSchema. You can restrict access to the Force flag in an Identity and Access Management (IAM) policy. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_document",
        op_kwargs={
            "Name": name,
            "DocumentVersion": document_version,
            "VersionName": version_name,
            "Force": force,
        },
    )


async def describe(
    hub, ctx, name: str, document_version: str = None, version_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified Amazon Web Services Systems Manager document (SSM document).

    Args:
        name(str): The name of the SSM document.
        document_version(str, optional): The document version for which you want information. Can be a specific version or the default version. Defaults to None.
        version_name(str, optional): An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.init.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.init.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_document",
        op_kwargs={
            "Name": name,
            "DocumentVersion": document_version,
            "VersionName": version_name,
        },
    )


async def get(
    hub,
    ctx,
    name: str,
    version_name: str = None,
    document_version: str = None,
    document_format: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).

    Args:
        name(str): The name of the SSM document.
        version_name(str, optional): An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document and can't be changed. Defaults to None.
        document_version(str, optional): The document version for which you want information. Defaults to None.
        document_format(str, optional): Returns the document in the specified format. The document format can be either JSON or YAML. JSON is the default format. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_document",
        op_kwargs={
            "Name": name,
            "VersionName": version_name,
            "DocumentVersion": document_version,
            "DocumentFormat": document_format,
        },
    )


async def list_all(
    hub,
    ctx,
    document_filter_list: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns all Systems Manager (SSM) documents in the current account and Region. You can limit the results of this request by using a filter.

    Args:
        document_filter_list(List, optional): This data type is deprecated. Instead, use Filters. Defaults to None.
        filters(List, optional): One or more DocumentKeyValuesFilter objects. Use a filter to return a more specific list of results. For keys, you can specify one or more key-value pair tags that have been applied to a document. Other valid keys include Owner, Name, PlatformTypes, DocumentType, and TargetType. For example, to return documents you own use Key=Owner,Values=Self. To specify a custom key-value pair, use the format Key=tag:tagName,Values=valueName.  This API operation only supports filtering documents by using a single tag key and one or more tag values. For example: Key=tag:tagName,Values=valueName1,valueName2  . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_documents",
        op_kwargs={
            "DocumentFilterList": document_filter_list,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    content: str,
    name: str,
    attachments: List = None,
    display_name: str = None,
    version_name: str = None,
    document_version: str = None,
    document_format: str = None,
    target_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates one or more values for an SSM document.

    Args:
        content(str): A valid JSON or YAML string.
        attachments(List, optional): A list of key-value pairs that describe attachments to a version of a document. Defaults to None.
        name(str): The name of the SSM document that you want to update.
        display_name(str, optional): The friendly name of the SSM document that you want to update. This value can differ for each version of the document. If you don't specify a value for this parameter in your request, the existing value is applied to the new document version. Defaults to None.
        version_name(str, optional): An optional field specifying the version of the artifact you are updating with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed. Defaults to None.
        document_version(str, optional): The version of the document that you want to update. Currently, Systems Manager supports updating only the latest version of the document. You can specify the version number of the latest version or use the $LATEST variable. Defaults to None.
        document_format(str, optional): Specify the document format for the new document version. Systems Manager supports JSON and YAML documents. JSON is the default format. Defaults to None.
        target_type(str, optional): Specify a new target type for the document. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.init.update(ctx, content=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.init.update content=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_document",
        op_kwargs={
            "Content": content,
            "Attachments": attachments,
            "Name": name,
            "DisplayName": display_name,
            "VersionName": version_name,
            "DocumentVersion": document_version,
            "DocumentFormat": document_format,
            "TargetType": target_type,
        },
    )
