"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, name: str, document_version: str) -> Dict:
    r"""
    **Autogenerated function**

    Set the default version of a document.

    Args:
        name(str): The name of a custom document that you want to set as the default version.
        document_version(str): The version of a custom document that you want to set as the default version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.document.default_version.update(
                ctx, name=value, document_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.document.default_version.update name=value, document_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_document_default_version",
        op_kwargs={"Name": name, "DocumentVersion": document_version},
    )
