"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, instance_id: str, snapshot_id: str, baseline_override: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the AWS-RunPatchBaseline Systems Manager document (SSM document).  If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your local AWS credentials and the operation fails. To avoid this, you can run the command in the Amazon Web Services Systems Manager console. Use Run Command, a capability of Amazon Web Services Systems Manager, with an SSM document that enables you to target an instance with a script or command. For example, run the command using the AWS-RunShellScript document or the AWS-RunPowerShellScript document.

    Args:
        instance_id(str): The ID of the instance for which the appropriate patch snapshot should be retrieved.
        snapshot_id(str): The snapshot ID provided by the user when running AWS-RunPatchBaseline.
        baseline_override(Dict, optional): Defines the basic information about a patch baseline override. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.deployable_patch_snapshot_for_instance.get(
                ctx, instance_id=value, snapshot_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.deployable_patch_snapshot_for_instance.get instance_id=value, snapshot_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_deployable_patch_snapshot_for_instance",
        op_kwargs={
            "InstanceId": instance_id,
            "SnapshotId": snapshot_id,
            "BaselineOverride": baseline_override,
        },
    )
