"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, operating_system: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system. If you don't specify an operating system value, the default patch baseline for Windows is returned.

    Args:
        operating_system(str, optional): Returns the default patch baseline for the specified operating system. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.default_patch_baseline.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.default_patch_baseline.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_default_patch_baseline",
        op_kwargs={"OperatingSystem": operating_system},
    )


async def register(hub, ctx, baseline_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Defines the default patch baseline for the relevant operating system. To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline Amazon Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed instead of pb-0574b43a65ea646ed.

    Args:
        baseline_id(str): The ID of the patch baseline that should be the default patch baseline.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.default_patch_baseline.register(ctx, baseline_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.default_patch_baseline.register baseline_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="register_default_patch_baseline",
        op_kwargs={"BaselineId": baseline_id},
    )
