"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, target: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the Session Manager connection status for an instance to determine whether it is running and ready to receive Session Manager connections.

    Args:
        target(str): The ID of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.connection_status.get(ctx, target=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.connection_status.get target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_connection_status",
        op_kwargs={"Target": target},
    )
