"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub, ctx, filters: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call can return State Manager associations, patches, or custom compliance types according to the filter criteria that you specify.

    Args:
        filters(List, optional): One or more compliance or inventory filters. Use a filter to return a more specific list of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. Currently, you can specify null or 50. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.compliance.summary.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.compliance.summary.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_compliance_summaries",
        op_kwargs={
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
