"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    filters: List = None,
    resource_ids: List = None,
    resource_types: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    For a specified resource ID, this API operation returns a list of compliance statuses for different resource types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the filter.

    Args:
        filters(List, optional): One or more compliance filters. Use a filter to return a more specific list of results. Defaults to None.
        resource_ids(List, optional): The ID for the resources from which to get compliance information. Currently, you can only specify one resource ID. Defaults to None.
        resource_types(List, optional): The type of resource from which to get compliance information. Currently, the only supported resource type is ManagedInstance. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.compliance.item.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.compliance.item.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_compliance_items",
        op_kwargs={
            "Filters": filters,
            "ResourceIds": resource_ids,
            "ResourceTypes": resource_types,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def put_multiple(
    hub,
    ctx,
    resource_id: str,
    resource_type: str,
    compliance_type: str,
    execution_summary: Dict,
    items: List,
    item_content_hash: str = None,
    upload_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers a compliance type and other compliance details on a designated resource. This operation lets you register custom compliance details with a resource. This call overwrites existing compliance information on the resource, so you must provide a full list of compliance items each time that you send the request. ComplianceType can be one of the following:   ExecutionId: The execution ID when the patch, association, or custom compliance item was applied.   ExecutionType: Specify patch, association, or Custom:string.   ExecutionTime. The time the patch, association, or custom compliance item was applied to the instance.   Id: The patch, association, or custom compliance ID.   Title: A title.   Status: The status of the compliance item. For example, approved for patches, or Failed for associations.   Severity: A patch severity. For example, critical.   DocumentName: An SSM document name. For example, AWS-RunPatchBaseline.   DocumentVersion: An SSM document version number. For example, 4.   Classification: A patch classification. For example, security updates.   PatchBaselineId: A patch baseline ID.   PatchSeverity: A patch severity. For example, Critical.   PatchState: A patch state. For example, InstancesWithFailedPatches.   PatchGroup: The name of a patch group.   InstalledTime: The time the association, patch, or custom compliance item was applied to the resource. Specify the time by using the following format: yyyy-MM-dd'T'HH:mm:ss'Z'

    Args:
        resource_id(str): Specify an ID for this resource. For a managed instance, this is the instance ID.
        resource_type(str): Specify the type of resource. ManagedInstance is currently the only supported resource type.
        compliance_type(str): Specify the compliance type. For example, specify Association (for a State Manager association), Patch, or Custom:string.
        execution_summary(Dict): A summary of the call execution that includes an execution ID, the type of execution (for example, Command), and the date/time of the execution using a datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
        items(List): Information about the compliance as defined by the resource type. For example, for a patch compliance type, Items includes information about the PatchSeverity, Classification, and so on.
        item_content_hash(str, optional): MD5 or SHA-256 content hash. The content hash is used to determine if existing information should be overwritten or ignored. If the content hashes match, the request to put compliance information is ignored. Defaults to None.
        upload_type(str, optional): The mode for uploading compliance items. You can specify COMPLETE or PARTIAL. In COMPLETE mode, the system overwrites all existing compliance information for the resource. You must provide a full list of compliance items each time you send the request. In PARTIAL mode, the system overwrites compliance information for a specific association. The association must be configured with SyncCompliance set to MANUAL. By default, all requests use COMPLETE mode.  This attribute is only valid for association compliance. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.compliance.item.put_multiple(
                ctx,
                resource_id=value,
                resource_type=value,
                compliance_type=value,
                execution_summary=value,
                items=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.compliance.item.put_multiple resource_id=value, resource_type=value, compliance_type=value, execution_summary=value, items=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="put_compliance_items",
        op_kwargs={
            "ResourceId": resource_id,
            "ResourceType": resource_type,
            "ComplianceType": compliance_type,
            "ExecutionSummary": execution_summary,
            "Items": items,
            "ItemContentHash": item_content_hash,
            "UploadType": upload_type,
        },
    )
