"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, command_id: str, instance_ids: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be terminated and the underlying process stopped.

    Args:
        command_id(str): The ID of the command you want to cancel.
        instance_ids(List, optional): (Optional) A list of instance IDs on which you want to cancel the command. If not provided, the command is canceled on every instance on which it was requested. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.command.init.cancel(ctx, command_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.command.init.cancel command_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="cancel_command",
        op_kwargs={"CommandId": command_id, "InstanceIds": instance_ids},
    )


async def list_all(
    hub,
    ctx,
    command_id: str = None,
    instance_id: str = None,
    max_results: int = None,
    next_token: str = None,
    filters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the commands requested by users of the account.

    Args:
        command_id(str, optional): (Optional) If provided, lists only the specified command. Defaults to None.
        instance_id(str, optional): (Optional) Lists commands issued against this instance ID.  You can't specify an instance ID in the same command that you specify Status = Pending. This is because the command hasn't reached the instance yet. . Defaults to None.
        max_results(int, optional): (Optional) The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): (Optional) The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        filters(List, optional): (Optional) One or more filters. Use a filter to return a more specific list of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.command.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.command.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_commands",
        op_kwargs={
            "CommandId": command_id,
            "InstanceId": instance_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
        },
    )


async def send(
    hub,
    ctx,
    document_name: str,
    instance_ids: List = None,
    targets: List = None,
    document_version: str = None,
    document_hash: str = None,
    document_hash_type: str = None,
    timeout_seconds: int = None,
    comment: str = None,
    parameters: Dict = None,
    output_s3_region: str = None,
    output_s3_bucket_name: str = None,
    output_s3_key_prefix: str = None,
    max_concurrency: str = None,
    max_errors: str = None,
    service_role_arn: str = None,
    notification_config: Dict = None,
    cloud_watch_output_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs commands on one or more managed instances.

    Args:
        instance_ids(List, optional): The IDs of the instances where the command should run. Specifying instance IDs is most useful when you are targeting a limited number of instances, though you can specify up to 50 IDs. To target a larger number of instances, or if you prefer not to list individual instance IDs, we recommend using the Targets option instead. Using Targets, which accepts tag key-value pairs to identify the instances to send commands to, you can a send command to tens, hundreds, or thousands of instances at once. For more information about how to use targets, see Using targets and rate controls to send commands to a fleet in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        targets(List, optional): An array of search criteria that targets instances using a Key,Value combination that you specify. Specifying targets is most useful when you want to send a command to a large number of instances at once. Using Targets, which accepts tag key-value pairs to identify instances, you can send a command to tens, hundreds, or thousands of instances at once. To send a command to a smaller number of instances, you can use the InstanceIds option instead. For more information about how to use targets, see Sending commands to a fleet in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        document_name(str): The name of the Amazon Web Services Systems Manager document (SSM document) to run. This can be a public document or a custom document. To run a shared document belonging to another account, specify the document ARN. For more information about how to use shared documents, see Using shared SSM documents in the Amazon Web Services Systems Manager User Guide.
        document_version(str, optional): The SSM document version to use in the request. You can specify $DEFAULT, $LATEST, or a specific version number. If you run commands by using the Command Line Interface (Amazon Web Services CLI), then you must escape the first two options by using a backslash. If you specify a version number, then you don't need to use the backslash. For example: --document-version "\$DEFAULT" --document-version "\$LATEST" --document-version "3". Defaults to None.
        document_hash(str, optional): The Sha256 or Sha1 hash created by the system when the document was created.   Sha1 hashes have been deprecated. . Defaults to None.
        document_hash_type(str, optional): Sha256 or Sha1.  Sha1 hashes have been deprecated. . Defaults to None.
        timeout_seconds(int, optional): If this time is reached and the command hasn't already started running, it won't run. Defaults to None.
        comment(str, optional): User-specified information about the command, such as a brief description of what the command should do. Defaults to None.
        parameters(Dict, optional): The required and optional parameters specified in the document being run. Defaults to None.
        output_s3_region(str, optional): (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager automatically determines the Region of the S3 bucket. Defaults to None.
        output_s3_bucket_name(str, optional): The name of the S3 bucket where command execution responses should be stored. Defaults to None.
        output_s3_key_prefix(str, optional): The directory structure within the S3 bucket where the responses should be stored. Defaults to None.
        max_concurrency(str, optional): (Optional) The maximum number of instances that are allowed to run the command at the same time. You can specify a number such as 10 or a percentage such as 10%. The default value is 50. For more information about how to use MaxConcurrency, see Using concurrency controls in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        max_errors(str, optional): The maximum number of errors allowed without the command failing. When the command fails one more time beyond the value of MaxErrors, the systems stops sending the command to additional targets. You can specify a number like 10 or a percentage like 10%. The default value is 0. For more information about how to use MaxErrors, see Using error controls in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        service_role_arn(str, optional): The ARN of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for Run Command commands. Defaults to None.
        notification_config(Dict, optional): Configurations for sending notifications. Defaults to None.
        cloud_watch_output_config(Dict, optional): Enables Amazon Web Services Systems Manager to send Run Command output to Amazon CloudWatch Logs. Run Command is a capability of Amazon Web Services Systems Manager. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.command.init.send(ctx, document_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.command.init.send document_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="send_command",
        op_kwargs={
            "InstanceIds": instance_ids,
            "Targets": targets,
            "DocumentName": document_name,
            "DocumentVersion": document_version,
            "DocumentHash": document_hash,
            "DocumentHashType": document_hash_type,
            "TimeoutSeconds": timeout_seconds,
            "Comment": comment,
            "Parameters": parameters,
            "OutputS3Region": output_s3_region,
            "OutputS3BucketName": output_s3_bucket_name,
            "OutputS3KeyPrefix": output_s3_key_prefix,
            "MaxConcurrency": max_concurrency,
            "MaxErrors": max_errors,
            "ServiceRoleArn": service_role_arn,
            "NotificationConfig": notification_config,
            "CloudWatchOutputConfig": cloud_watch_output_config,
        },
    )
