"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def start(
    hub,
    ctx,
    document_name: str,
    runbooks: List,
    scheduled_time: str = None,
    document_version: str = None,
    parameters: Dict = None,
    change_request_name: str = None,
    client_token: str = None,
    tags: List = None,
    scheduled_end_time: str = None,
    change_details: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a change request for Change Manager. The Automation runbooks specified in the change request run only after all required approvals for the change request have been received.

    Args:
        scheduled_time(str, optional): The date and time specified in the change request to run the Automation runbooks.  The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received. . Defaults to None.
        document_name(str): The name of the change template document to run during the runbook workflow.
        document_version(str, optional): The version of the change template document to run during the runbook workflow. Defaults to None.
        parameters(Dict, optional): A key-value map of parameters that match the declared parameters in the change template document. Defaults to None.
        change_request_name(str, optional): The name of the change request associated with the runbook workflow to be run. Defaults to None.
        client_token(str, optional): The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can't be reused. Defaults to None.
        runbooks(List): Information about the Automation runbooks that are run during the runbook workflow.  The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received. .
        tags(List, optional): Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a change request to identify an environment or target Region. In this case, you could specify the following key-value pairs:    Key=Environment,Value=Production     Key=Region,Value=us-east-2   . Defaults to None.
        scheduled_end_time(str, optional): The time that the requester expects the runbook workflow related to the change request to complete. The time is an estimate only that the requester provides for reviewers. Defaults to None.
        change_details(str, optional): User-provided details about the change. If no details are provided, content specified in the Template information section of the associated change template is added. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.change_request_execution.start(
                ctx, document_name=value, runbooks=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.change_request_execution.start document_name=value, runbooks=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="start_change_request_execution",
        op_kwargs={
            "ScheduledTime": scheduled_time,
            "DocumentName": document_name,
            "DocumentVersion": document_version,
            "Parameters": parameters,
            "ChangeRequestName": change_request_name,
            "ClientToken": client_token,
            "Runbooks": runbooks,
            "Tags": tags,
            "ScheduledEndTime": scheduled_end_time,
            "ChangeDetails": change_details,
        },
    )
