"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    automation_execution_id: str,
    filters: List = None,
    next_token: str = None,
    max_results: int = None,
    reverse_order: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Information about all active and terminated step executions in an Automation workflow.

    Args:
        automation_execution_id(str): The Automation execution ID for which you want step execution descriptions.
        filters(List, optional): One or more filters to limit the number of step executions returned by the request. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        reverse_order(bool, optional): Indicates whether to list step executions in reverse order by start time. The default value is 'false'. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.automation.step_execution.describe_all(
                ctx, automation_execution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.automation.step_execution.describe_all automation_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_automation_step_executions",
        op_kwargs={
            "AutomationExecutionId": automation_execution_id,
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
            "ReverseOrder": reverse_order,
        },
    )
