"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub, ctx, automation_execution_id: str, signal_type: str, payload: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Sends a signal to an Automation execution to change the current behavior or status of the execution.

    Args:
        automation_execution_id(str): The unique identifier for an existing Automation execution that you want to send the signal to.
        signal_type(str): The type of signal to send to an Automation execution. .
        payload(Dict, optional): The data sent with the signal. The data schema depends on the type of signal used in the request. For Approve and Reject signal types, the payload is an optional comment that you can send with the signal type. For example:  Comment="Looks good"  For StartStep and Resume signal types, you must send the name of the Automation step to start or resume as the payload. For example:  StepName="step1"  For the StopStep signal type, you must send the step execution ID as the payload. For example:  StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab" . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.automation.signal.send(
                ctx, automation_execution_id=value, signal_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.automation.signal.send automation_execution_id=value, signal_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="send_automation_signal",
        op_kwargs={
            "AutomationExecutionId": automation_execution_id,
            "SignalType": signal_type,
            "Payload": payload,
        },
    )
