"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides details about all active and terminated Automation executions.

    Args:
        filters(List, optional): Filters used to limit the scope of executions that are requested. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.automation.execution.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.automation.execution.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_automation_executions",
        op_kwargs={
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def get(hub, ctx, automation_execution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get detailed information about a particular Automation execution.

    Args:
        automation_execution_id(str): The unique identifier for an existing automation execution to examine. The execution ID is returned by StartAutomationExecution when the execution of an Automation runbook is initiated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.automation.execution.get(ctx, automation_execution_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.automation.execution.get automation_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="get_automation_execution",
        op_kwargs={"AutomationExecutionId": automation_execution_id},
    )


async def start(
    hub,
    ctx,
    document_name: str,
    document_version: str = None,
    parameters: Dict = None,
    client_token: str = None,
    mode: str = None,
    target_parameter_name: str = None,
    targets: List = None,
    target_maps: List = None,
    max_concurrency: str = None,
    max_errors: str = None,
    target_locations: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Initiates execution of an Automation runbook.

    Args:
        document_name(str): The name of the SSM document to run. This can be a public document or a custom document. To run a shared document belonging to another account, specify the document ARN. For more information about how to use shared documents, see Using shared SSM documents in the Amazon Web Services Systems Manager User Guide.
        document_version(str, optional): The version of the Automation runbook to use for this execution. Defaults to None.
        parameters(Dict, optional): A key-value map of execution parameters, which match the declared parameters in the Automation runbook. Defaults to None.
        client_token(str, optional): User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can't be reused. Defaults to None.
        mode(str, optional): The execution mode of the automation. Valid modes include the following: Auto and Interactive. The default mode is Auto. Defaults to None.
        target_parameter_name(str, optional): The name of the parameter used as the target resource for the rate-controlled execution. Required if you specify targets. Defaults to None.
        targets(List, optional): A key-value mapping to target resources. Required if you specify TargetParameterName. Defaults to None.
        target_maps(List, optional): A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified together. Defaults to None.
        max_concurrency(str, optional): The maximum number of targets allowed to run this task in parallel. You can specify a number, such as 10, or a percentage, such as 10%. The default value is 10. Defaults to None.
        max_errors(str, optional): The number of errors that are allowed before the system stops running the automation on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops running the automation when the fourth error is received. If you specify 0, then the system stops running the automation on additional targets after the first error result is returned. If you run an automation on 50 resources and set max-errors to 10%, then the system stops running the automation on additional targets when the sixth error is received. Executions that are already running an automation when max-errors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set max-concurrency to 1 so the executions proceed one at a time. Defaults to None.
        target_locations(List, optional): A location is a combination of Regions and/or accounts where you want to run the automation. Use this operation to start an automation in multiple Regions and multiple accounts. For more information, see Running Automation workflows in multiple Regions and accounts in the Amazon Web Services Systems Manager User Guide. . Defaults to None.
        tags(List, optional): Optional metadata that you assign to a resource. You can specify a maximum of five tags for an automation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an automation to identify an environment or operating system. In this case, you could specify the following key-value pairs:    Key=environment,Value=test     Key=OS,Value=Windows     To add tags to an existing patch baseline, use the AddTagsToResource operation. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.automation.execution.start(ctx, document_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.automation.execution.start document_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="start_automation_execution",
        op_kwargs={
            "DocumentName": document_name,
            "DocumentVersion": document_version,
            "Parameters": parameters,
            "ClientToken": client_token,
            "Mode": mode,
            "TargetParameterName": target_parameter_name,
            "Targets": targets,
            "TargetMaps": target_maps,
            "MaxConcurrency": max_concurrency,
            "MaxErrors": max_errors,
            "TargetLocations": target_locations,
            "Tags": tags,
        },
    )


async def stop(hub, ctx, automation_execution_id: str, type_: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Stop an Automation that is currently running.

    Args:
        automation_execution_id(str): The execution ID of the Automation to stop.
        type_(str, optional): The stop request type. Valid types include the following: Cancel and Complete. The default type is Cancel. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.automation.execution.stop(
                ctx, automation_execution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.automation.execution.stop automation_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="stop_automation_execution",
        op_kwargs={"AutomationExecutionId": automation_execution_id, "Type": type_},
    )
