"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, association_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all versions of an association for a specific association ID.

    Args:
        association_id(str): The association ID for which you want to view all versions.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.version.list_all(ctx, association_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.version.list_all association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_association_versions",
        op_kwargs={
            "AssociationId": association_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
