"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, name: str, instance_id: str, association_status: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the specified instance.

    Args:
        name(str): The name of the SSM document.
        instance_id(str): The ID of the instance.
        association_status(Dict): The association status.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.status.update(
                ctx, name=value, instance_id=value, association_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.status.update name=value, instance_id=value, association_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_association_status",
        op_kwargs={
            "Name": name,
            "InstanceId": instance_id,
            "AssociationStatus": association_status,
        },
    )
