"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def start(hub, ctx, association_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Runs an association immediately and only one time. This operation can be helpful when troubleshooting associations.

    Args:
        association_ids(List): The association IDs that you want to run immediately and only one time.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.once.start(ctx, association_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.once.start association_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="start_associations_once",
        op_kwargs={"AssociationIds": association_ids},
    )
