"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    document_version: str = None,
    instance_id: str = None,
    parameters: Dict = None,
    targets: List = None,
    schedule_expression: str = None,
    output_location: Dict = None,
    association_name: str = None,
    automation_target_parameter_name: str = None,
    max_errors: str = None,
    max_concurrency: str = None,
    compliance_severity: str = None,
    sync_compliance: str = None,
    apply_only_at_cron_interval: bool = None,
    calendar_names: List = None,
    target_locations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    A State Manager association defines the state that you want to maintain on your instances. For example, an association can specify that anti-virus software must be installed and running on your instances, or that certain ports must be closed. For static targets, the association specifies a schedule for when the configuration is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services autoscaling group, State Manager, a capability of Amazon Web Services Systems Manager applies the configuration when new instances are added to the group. The association also specifies actions to take when applying the configuration. For example, an association for anti-virus software might run once a day. If the software isn't installed, then State Manager installs it. If the software is installed, but the service isn't running, then the association might instruct State Manager to start the service.

    Args:
        name(str): The name of the SSM Command document or Automation runbook that contains the configuration information for the instance. You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account. For Systems Manager documents (SSM documents) that are shared with you from other accounts, you must specify the complete SSM document ARN, in the following format:  arn:partition:ssm:region:account-id:document/document-name   For example:  arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document  For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, AWS-ApplyPatchBaseline or My-Document.
        document_version(str, optional): The document version you want to associate with the target(s). Can be a specific version or the default version. Defaults to None.
        instance_id(str, optional): The instance ID.   InstanceId has been deprecated. To specify an instance ID for an association, use the Targets parameter. Requests that include the parameter InstanceID with Systems Manager documents (SSM documents) that use schema version 2.0 or later will fail. In addition, if you use the parameter InstanceId, you can't use the parameters AssociationName, DocumentVersion, MaxErrors, MaxConcurrency, OutputLocation, or ScheduleExpression. To use these parameters, you must use the Targets parameter. . Defaults to None.
        parameters(Dict, optional): The parameters for the runtime configuration of the document. Defaults to None.
        targets(List, optional): The targets for the association. You can target instances by using tags, Amazon Web Services resource groups, all instances in an account, or individual instance IDs. For more information about choosing targets for an association, see Using targets and rate controls with State Manager associations in the Amazon Web Services Systems Manager User Guide. Defaults to None.
        schedule_expression(str, optional): A cron expression when the association will be applied to the target(s). Defaults to None.
        output_location(Dict, optional): An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request. Defaults to None.
        association_name(str, optional): Specify a descriptive name for the association. Defaults to None.
        automation_target_parameter_name(str, optional): Specify the target for the association. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager. Defaults to None.
        max_errors(str, optional): The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 instances and set MaxError to 10%, then the system stops sending the request when the sixth error is received. Executions that are already running an association when MaxErrors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a time. Defaults to None.
        max_concurrency(str, optional): The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time. If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency associations, the association is allowed to run. During the next association interval, the new instance will process its association within the limit specified for MaxConcurrency. Defaults to None.
        compliance_severity(str, optional): The severity level to assign to the association. Defaults to None.
        sync_compliance(str, optional): The mode for generating association compliance. You can specify AUTO or MANUAL. In AUTO mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is COMPLIANT. If the association execution doesn't run successfully, the association is NON-COMPLIANT. In MANUAL mode, you must specify the AssociationId as a parameter for the PutComplianceItems API operation. In this case, compliance data isn't managed by State Manager. It is managed by your direct call to the PutComplianceItems API operation. By default, all associations use AUTO mode. Defaults to None.
        apply_only_at_cron_interval(bool, optional): By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter isn't supported for rate expressions. Defaults to None.
        calendar_names(List, optional): The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see Amazon Web Services Systems Manager Change Calendar. Defaults to None.
        target_locations(List, optional): A location is a combination of Regions and accounts where you want to run the association. Use this action to create an association in multiple Regions and multiple accounts. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_association",
        op_kwargs={
            "Name": name,
            "DocumentVersion": document_version,
            "InstanceId": instance_id,
            "Parameters": parameters,
            "Targets": targets,
            "ScheduleExpression": schedule_expression,
            "OutputLocation": output_location,
            "AssociationName": association_name,
            "AutomationTargetParameterName": automation_target_parameter_name,
            "MaxErrors": max_errors,
            "MaxConcurrency": max_concurrency,
            "ComplianceSeverity": compliance_severity,
            "SyncCompliance": sync_compliance,
            "ApplyOnlyAtCronInterval": apply_only_at_cron_interval,
            "CalendarNames": calendar_names,
            "TargetLocations": target_locations,
        },
    )


async def delete(
    hub, ctx, name: str = None, instance_id: str = None, association_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified instance. When you disassociate a document from an instance, it doesn't change the configuration of the instance. To change the configuration state of an instance after you disassociate a document, you must create a new document with the desired configuration and associate it with the instance.

    Args:
        name(str, optional): The name of the SSM document. Defaults to None.
        instance_id(str, optional): The ID of the instance. Defaults to None.
        association_id(str, optional): The association ID that you want to delete. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_association",
        op_kwargs={
            "Name": name,
            "InstanceId": instance_id,
            "AssociationId": association_id,
        },
    )


async def describe(
    hub,
    ctx,
    name: str = None,
    instance_id: str = None,
    association_id: str = None,
    association_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the association for the specified target or instance. If you created the association by using the Targets parameter, then you must retrieve the association by using the association ID. If you created the association by specifying an instance ID and an Amazon Web Services Systems Manager document (SSM document), then you retrieve the association by specifying the document name and the instance ID.

    Args:
        name(str, optional): The name of the SSM document. Defaults to None.
        instance_id(str, optional): The instance ID. Defaults to None.
        association_id(str, optional): The association ID for which you want information. Defaults to None.
        association_version(str, optional): Specify the association version to retrieve. To view the latest version, either specify $LATEST for this parameter, or omit this parameter. To view a list of all associations for an instance, use ListAssociations. To get a list of versions for a specific association, use ListAssociationVersions. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_association",
        op_kwargs={
            "Name": name,
            "InstanceId": instance_id,
            "AssociationId": association_id,
            "AssociationVersion": association_version,
        },
    )


async def list_all(
    hub,
    ctx,
    association_filter_list: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns all State Manager associations in the current account and Region. You can limit the results to a specific State Manager association document or instance by specifying a filter. State Manager is a capability of Amazon Web Services Systems Manager.

    Args:
        association_filter_list(List, optional): One or more filters. Use a filter to return a more specific list of results.  Filtering associations using the InstanceID attribute only returns legacy associations created using the InstanceID attribute. Associations targeting the instance that are part of the Target Attributes ResourceGroup or Tags aren't returned. . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a previous call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="list_associations",
        op_kwargs={
            "AssociationFilterList": association_filter_list,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    association_id: str,
    parameters: Dict = None,
    document_version: str = None,
    schedule_expression: str = None,
    output_location: Dict = None,
    name: str = None,
    targets: List = None,
    association_name: str = None,
    association_version: str = None,
    automation_target_parameter_name: str = None,
    max_errors: str = None,
    max_concurrency: str = None,
    compliance_severity: str = None,
    sync_compliance: str = None,
    apply_only_at_cron_interval: bool = None,
    calendar_names: List = None,
    target_locations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an association. You can update the association name and version, the document version, schedule, parameters, and Amazon Simple Storage Service (Amazon S3) output.  In order to call this API operation, your Identity and Access Management (IAM) user account, group, or role must be configured with permission to call the DescribeAssociation API operation. If you don't have permission to call DescribeAssociation, then you receive the following error: An error occurred (AccessDeniedException) when calling the UpdateAssociation operation: User: <user_arn> isn't authorized to perform: ssm:DescribeAssociation on resource: <resource_arn>   When you update an association, the association immediately runs against the specified targets.

    Args:
        association_id(str): The ID of the association you want to update. .
        parameters(Dict, optional): The parameters you want to update for the association. If you create a parameter using Parameter Store, a capability of Amazon Web Services Systems Manager, you can reference the parameter using {{ssm:parameter-name}}. Defaults to None.
        document_version(str, optional): The document version you want update for the association. . Defaults to None.
        schedule_expression(str, optional): The cron expression used to schedule the association that you want to update. Defaults to None.
        output_location(Dict, optional): An S3 bucket where you want to store the results of this request. Defaults to None.
        name(str, optional): The name of the SSM Command document or Automation runbook that contains the configuration information for the instance. You can specify Amazon Web Services-predefined documents, documents you created, or a document that is shared with you from another account. For Systems Manager document (SSM document) that are shared with you from other accounts, you must specify the complete SSM document ARN, in the following format:  arn:aws:ssm:region:account-id:document/document-name   For example:  arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document  For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, AWS-ApplyPatchBaseline or My-Document. Defaults to None.
        targets(List, optional): The targets of the association. Defaults to None.
        association_name(str, optional): The name of the association that you want to update. Defaults to None.
        association_version(str, optional): This parameter is provided for concurrency control purposes. You must specify the latest association version in the service. If you want to ensure that this request succeeds, either specify $LATEST, or omit this parameter. Defaults to None.
        automation_target_parameter_name(str, optional): Specify the target for the association. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a capability of Amazon Web Services Systems Manager. Defaults to None.
        max_errors(str, optional): The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 instances and set MaxError to 10%, then the system stops sending the request when the sixth error is received. Executions that are already running an association when MaxErrors is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a time. Defaults to None.
        max_concurrency(str, optional): The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time. If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency associations, the association is allowed to run. During the next association interval, the new instance will process its association within the limit specified for MaxConcurrency. Defaults to None.
        compliance_severity(str, optional): The severity level to assign to the association. Defaults to None.
        sync_compliance(str, optional): The mode for generating association compliance. You can specify AUTO or MANUAL. In AUTO mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is COMPLIANT. If the association execution doesn't run successfully, the association is NON-COMPLIANT. In MANUAL mode, you must specify the AssociationId as a parameter for the PutComplianceItems API operation. In this case, compliance data isn't managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the PutComplianceItems API operation. By default, all associations use AUTO mode. Defaults to None.
        apply_only_at_cron_interval(bool, optional): By default, when you update an association, the system runs it immediately after it is updated and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you update it. This parameter isn't supported for rate expressions. Also, if you specified this option when you created the association, you can reset it. To do so, specify the no-apply-only-at-cron-interval parameter when you update the association from the command line. This parameter forces the association to run immediately after updating it and according to the interval specified. Defaults to None.
        calendar_names(List, optional): The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to gate your associations under. The associations only run when that change calendar is open. For more information, see Amazon Web Services Systems Manager Change Calendar. Defaults to None.
        target_locations(List, optional): A location is a combination of Regions and accounts where you want to run the association. Use this action to update an association in multiple Regions and multiple accounts. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.init.update(ctx, association_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.init.update association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="update_association",
        op_kwargs={
            "AssociationId": association_id,
            "Parameters": parameters,
            "DocumentVersion": document_version,
            "ScheduleExpression": schedule_expression,
            "OutputLocation": output_location,
            "Name": name,
            "Targets": targets,
            "AssociationName": association_name,
            "AssociationVersion": association_version,
            "AutomationTargetParameterName": automation_target_parameter_name,
            "MaxErrors": max_errors,
            "MaxConcurrency": max_concurrency,
            "ComplianceSeverity": compliance_severity,
            "SyncCompliance": sync_compliance,
            "ApplyOnlyAtCronInterval": apply_only_at_cron_interval,
            "CalendarNames": calendar_names,
            "TargetLocations": target_locations,
        },
    )
