"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, entries: List) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified instances or targets. When you associate a document with one or more instances using instance IDs or tags, Amazon Web Services Systems Manager Agent (SSM Agent) running on the instance processes the document and configures the instance as specified. If you associate a document with an instance that already has an associated document, the system returns the AssociationAlreadyExists exception.

    Args:
        entries(List): One or more associations.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.association.batch.create(ctx, entries=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.association.batch.create entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_association_batch",
        op_kwargs={"Entries": entries},
    )
