"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    iam_role: str,
    description: str = None,
    default_instance_name: str = None,
    registration_limit: int = None,
    expiration_date: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates an activation code and activation ID you can use to register your on-premises server or virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing on-premises instances and VMs using Systems Manager, see Setting up Amazon Web Services Systems Manager for hybrid environments in the Amazon Web Services Systems Manager User Guide.   On-premises servers or VMs that are registered with Systems Manager and Amazon Elastic Compute Cloud (Amazon EC2) instances that you manage with Systems Manager are all called managed instances.

    Args:
        description(str, optional): A user-defined description of the resource that you want to register with Systems Manager.   Don't enter personally identifiable information in this field. . Defaults to None.
        default_instance_name(str, optional): The name of the registered, managed instance as it will appear in the Amazon Web Services Systems Manager console or when you use the Amazon Web Services command line tools to list Systems Manager resources.  Don't enter personally identifiable information in this field. . Defaults to None.
        iam_role(str): The Identity and Access Management (IAM) role that you want to assign to the managed instance. This IAMrole must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal ssm.amazonaws.com. For more information, see Create an IAM service role for a hybrid environment in the Amazon Web Services Systems Manager User Guide.
        registration_limit(int, optional): Specify the maximum number of managed instances you want to register. The default value is 1. Defaults to None.
        expiration_date(str, optional): The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires in 24 hours. Defaults to None.
        tags(List, optional): Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify the following key-value pairs:    Key=OS,Value=Windows     Key=Environment,Value=Production     When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises servers or VMs.  You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers and VMs after they connect to Systems Manager for the first time and are assigned a managed instance ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with "mi-". For information about how to add tags to your managed instances, see AddTagsToResource. For information about how to remove tags from your managed instances, see RemoveTagsFromResource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.activation.create(ctx, iam_role=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.activation.create iam_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="create_activation",
        op_kwargs={
            "Description": description,
            "DefaultInstanceName": default_instance_name,
            "IamRole": iam_role,
            "RegistrationLimit": registration_limit,
            "ExpirationDate": expiration_date,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, activation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an activation. You aren't required to delete an activation. If you delete an activation, you can no longer use it to register additional managed instances. Deleting an activation doesn't de-register managed instances. You must manually de-register managed instances.

    Args:
        activation_id(str): The ID of the activation that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.activation.delete(ctx, activation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.activation.delete activation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="delete_activation",
        op_kwargs={"ActivationId": activation_id},
    )


async def describe_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes details about the activation, such as the date and time the activation was created, its expiration date, the Identity and Access Management (IAM) role assigned to the instances in the activation, and the number of instances registered by using this activation.

    Args:
        filters(List, optional): A filter to view information about your activations. Defaults to None.
        max_results(int, optional): The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results. Defaults to None.
        next_token(str, optional): A token to start the list. Use this token to get the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ssm.activation.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ssm.activation.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ssm",
        operation="describe_activations",
        op_kwargs={
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
