"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, queue_name: str, queue_owner_aws_account_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the URL of an existing Amazon SQS queue. To access a queue that belongs to another AWS account, use the QueueOwnerAWSAccountId parameter to specify the account ID of the queue's owner. The queue's owner must grant you permission to access the queue. For more information about shared queue access, see  AddPermission  or see Allow Developers to Write Messages to a Shared Queue in the Amazon SQS Developer Guide.

    Args:
        queue_name(str): The name of the queue whose URL must be fetched. Maximum 80 characters. Valid values: alphanumeric characters, hyphens (-), and underscores (_). Queue URLs and names are case-sensitive.
        queue_owner_aws_account_id(str, optional): The account ID of the account that created the queue. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sqs.queue.url.get(ctx, queue_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sqs.queue.url.get queue_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sqs",
        operation="get_queue_url",
        op_kwargs={
            "QueueName": queue_name,
            "QueueOwnerAWSAccountId": queue_owner_aws_account_id,
        },
    )
