"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, queue_url: str) -> Dict:
    r"""
    **Autogenerated function**

    List all cost allocation tags added to the specified Amazon SQS queue. For an overview, see Tagging Your Amazon SQS Queues in the Amazon SQS Developer Guide.  Cross-account permissions don't apply to this action. For more information, see Grant cross-account permissions to a role and a user name in the Amazon SQS Developer Guide.

    Args:
        queue_url(str): The URL of the queue.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sqs.queue.tag.list_all(ctx, queue_url=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sqs.queue.tag.list_all queue_url=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sqs",
        operation="list_queue_tags",
        op_kwargs={"QueueUrl": queue_url},
    )
