"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def add(
    hub, ctx, queue_url: str, label: str, aws_account_ids: List, actions: List
) -> None:
    r"""
    **Autogenerated function**

    Adds a permission to a queue for a specific principal. This allows sharing access to the queue. When you create a queue, you have full control access rights for the queue. Only you, the owner of the queue, can grant or deny permissions to the queue. For more information about these permissions, see Allow Developers to Write Messages to a Shared Queue in the Amazon SQS Developer Guide.     AddPermission generates a policy for you. You can use  SetQueueAttributes  to upload your policy. For more information, see Using Custom Policies with the Amazon SQS Access Policy Language in the Amazon SQS Developer Guide.   An Amazon SQS policy can have a maximum of 7 actions.   To remove the ability to change queue permissions, you must deny permission to the AddPermission, RemovePermission, and SetQueueAttributes actions in your IAM policy.    Some actions take lists of parameters. These lists are specified using the param.n notation. Values of n are integers starting from 1. For example, a parameter list with two elements looks like this:  &AttributeName.1=first   &AttributeName.2=second   Cross-account permissions don't apply to this action. For more information, see Grant cross-account permissions to a role and a user name in the Amazon SQS Developer Guide.

    Args:
        queue_url(str): The URL of the Amazon SQS queue to which permissions are added. Queue URLs and names are case-sensitive.
        label(str): The unique identification of the permission you're setting (for example, AliceSendMessage). Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (-), and underscores (_).
        aws_account_ids(List): The account numbers of the principals who are to receive permission. For information about locating the account identification, see Your Amazon Web Services Identifiers in the Amazon SQS Developer Guide.
        actions(List): The action the client wants to allow for the specified principal. Valid values: the name of any action or *. For more information about these actions, see Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource in the Amazon SQS Developer Guide. Specifying SendMessage, DeleteMessage, or ChangeMessageVisibility for ActionName.n also grants permissions for the corresponding batch versions of those actions: SendMessageBatch, DeleteMessageBatch, and ChangeMessageVisibilityBatch.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sqs.permission.add(
                ctx, queue_url=value, label=value, aws_account_ids=value, actions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sqs.permission.add queue_url=value, label=value, aws_account_ids=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sqs",
        operation="add_permission",
        op_kwargs={
            "QueueUrl": queue_url,
            "Label": label,
            "AWSAccountIds": aws_account_ids,
            "Actions": actions,
        },
    )


async def remove(hub, ctx, queue_url: str, label: str) -> None:
    r"""
    **Autogenerated function**

    Revokes any permissions in the queue policy that matches the specified Label parameter.    Only the owner of a queue can remove permissions from it.   Cross-account permissions don't apply to this action. For more information, see Grant cross-account permissions to a role and a user name in the Amazon SQS Developer Guide.   To remove the ability to change queue permissions, you must deny permission to the AddPermission, RemovePermission, and SetQueueAttributes actions in your IAM policy.

    Args:
        queue_url(str): The URL of the Amazon SQS queue from which permissions are removed. Queue URLs and names are case-sensitive.
        label(str): The identification of the permission to remove. This is the label added using the  AddPermission  action.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sqs.permission.remove(ctx, queue_url=value, label=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sqs.permission.remove queue_url=value, label=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sqs",
        operation="remove_permission",
        op_kwargs={"QueueUrl": queue_url, "Label": label},
    )
