"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def change(hub, ctx, queue_url: str, entries: List) -> Dict:
    r"""
    **Autogenerated function**

    Changes the visibility timeout of multiple messages. This is a batch version of  ChangeMessageVisibility. The result of the action on each message is reported individually in the response. You can send up to 10  ChangeMessageVisibility  requests with each ChangeMessageVisibilityBatch action.  Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of 200.  Some actions take lists of parameters. These lists are specified using the param.n notation. Values of n are integers starting from 1. For example, a parameter list with two elements looks like this:  &AttributeName.1=first   &AttributeName.2=second

    Args:
        queue_url(str): The URL of the Amazon SQS queue whose messages' visibility is changed. Queue URLs and names are case-sensitive.
        entries(List): A list of receipt handles of the messages for which the visibility timeout must be changed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sqs.message.visibility.batch.change(
                ctx, queue_url=value, entries=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sqs.message.visibility.batch.change queue_url=value, entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sqs",
        operation="change_message_visibility_batch",
        op_kwargs={"QueueUrl": queue_url, "Entries": entries},
    )
