"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, queue_url: str, entries: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes up to ten messages from the specified queue. This is a batch version of  DeleteMessage. The result of the action on each message is reported individually in the response.  Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of 200.  Some actions take lists of parameters. These lists are specified using the param.n notation. Values of n are integers starting from 1. For example, a parameter list with two elements looks like this:  &AttributeName.1=first   &AttributeName.2=second

    Args:
        queue_url(str): The URL of the Amazon SQS queue from which messages are deleted. Queue URLs and names are case-sensitive.
        entries(List): A list of receipt handles for the messages to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sqs.message.batch.delete(ctx, queue_url=value, entries=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sqs.message.batch.delete queue_url=value, entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sqs",
        operation="delete_message_batch",
        op_kwargs={"QueueUrl": queue_url, "Entries": entries},
    )


async def send(hub, ctx, queue_url: str, entries: List) -> Dict:
    r"""
    **Autogenerated function**

    Delivers up to ten messages to the specified queue. This is a batch version of  SendMessage. For a FIFO queue, multiple messages within a single batch are enqueued in the order they are sent. The result of sending each message is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of 200. The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths of all of the batched messages) are both 256 KB (262,144 bytes).  A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:  #x9 | #xA | #xD | #x20 to #xD7FF | #xE000 to #xFFFD | #x10000 to #x10FFFF  Any characters not included in this list will be rejected. For more information, see the W3C specification for characters.  If you don't specify the DelaySeconds parameter for an entry, Amazon SQS uses the default value for the queue. Some actions take lists of parameters. These lists are specified using the param.n notation. Values of n are integers starting from 1. For example, a parameter list with two elements looks like this:  &AttributeName.1=first   &AttributeName.2=second

    Args:
        queue_url(str): The URL of the Amazon SQS queue to which batched messages are sent. Queue URLs and names are case-sensitive.
        entries(List): A list of  SendMessageBatchRequestEntry  items.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sqs.message.batch.send(ctx, queue_url=value, entries=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sqs.message.batch.send queue_url=value, entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sqs",
        operation="send_message_batch",
        op_kwargs={"QueueUrl": queue_url, "Entries": entries},
    )
