"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, queue_url: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of your queues that have the RedrivePolicy queue attribute configured with a dead-letter queue.  The ListDeadLetterSourceQueues methods supports pagination. Set parameter MaxResults in the request to specify the maximum number of results to be returned in the response. If you do not set MaxResults, the response includes a maximum of 1,000 results. If you set MaxResults and there are additional results to display, the response includes a value for NextToken. Use NextToken as a parameter in your next request to ListDeadLetterSourceQueues to receive the next page of results.  For more information about using dead-letter queues, see Using Amazon SQS Dead-Letter Queues in the Amazon SQS Developer Guide.

    Args:
        queue_url(str): The URL of a dead-letter queue. Queue URLs and names are case-sensitive.
        next_token(str, optional): Pagination token to request the next set of results. Defaults to None.
        max_results(int, optional): Maximum number of results to include in the response. Value range is 1 to 1000. You must set MaxResults to receive a value for NextToken in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sqs.dead_letter_source_queue.list_all(ctx, queue_url=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sqs.dead_letter_source_queue.list_all queue_url=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sqs",
        operation="list_dead_letter_source_queues",
        op_kwargs={
            "QueueUrl": queue_url,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
