"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get_all(hub, ctx, topic_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of the user.

    Args:
        topic_arn(str): The ARN of the topic whose properties you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.topic.attribute.get_all(ctx, topic_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.topic.attribute.get_all topic_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="get_topic_attributes",
        op_kwargs={"TopicArn": topic_arn},
    )


async def set_(
    hub, ctx, topic_arn: str, attribute_name: str, attribute_value: str = None
) -> None:
    r"""
    **Autogenerated function**

    Allows a topic owner to set an attribute of the topic to a new value.

    Args:
        topic_arn(str): The ARN of the topic to modify.
        attribute_name(str): A map of attributes with their corresponding values. The following lists the names, descriptions, and values of the special request parameters that the SetTopicAttributes action uses:    DeliveryPolicy – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.    DisplayName – The display name to use for a topic with SMS subscriptions.    Policy – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.   The following attribute applies only to server-side-encryption:    KmsMasterKeyId – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see Key Terms. For more examples, see KeyId in the Key Management Service API Reference.    The following attribute applies only to FIFO topics:    ContentBasedDeduplication – Enables content-based deduplication for FIFO topics.   By default, ContentBasedDeduplication is set to false. If you create a FIFO topic and this attribute is false, you must specify a value for the MessageDeduplicationId parameter for the Publish action.    When you set ContentBasedDeduplication to true, Amazon SNS uses a SHA-256 hash to generate the MessageDeduplicationId using the body of the message (but not the attributes of the message). (Optional) To override the generated value, you can specify a value for the MessageDeduplicationId parameter for the Publish action.    .
        attribute_value(str, optional): The new value for the attribute. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.topic.attribute.set(
                ctx, topic_arn=value, attribute_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.topic.attribute.set topic_arn=value, attribute_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="set_topic_attributes",
        op_kwargs={
            "TopicArn": topic_arn,
            "AttributeName": attribute_name,
            "AttributeValue": attribute_value,
        },
    )
