"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def confirm(
    hub, ctx, topic_arn: str, token: str, authenticate_on_unsubscribe: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Verifies an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an earlier Subscribe action. If the token is valid, the action creates a new subscription and returns its Amazon Resource Name (ARN). This call requires an AWS signature only when the AuthenticateOnUnsubscribe flag is set to "true".

    Args:
        topic_arn(str): The ARN of the topic for which you wish to confirm a subscription.
        token(str): Short-lived token sent to an endpoint during the Subscribe action.
        authenticate_on_unsubscribe(str, optional): Disallows unauthenticated unsubscribes of the subscription. If the value of this parameter is true and the request has an Amazon Web Services signature, then only the topic owner and the subscription owner can unsubscribe the endpoint. The unsubscribe action requires Amazon Web Services authentication. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.subscription.init.confirm(ctx, topic_arn=value, token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.subscription.init.confirm topic_arn=value, token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="confirm_subscription",
        op_kwargs={
            "TopicArn": topic_arn,
            "Token": token,
            "AuthenticateOnUnsubscribe": authenticate_on_unsubscribe,
        },
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a NextToken is also returned. Use the NextToken parameter in a new ListSubscriptions call to get further results. This action is throttled at 30 transactions per second (TPS).

    Args:
        next_token(str, optional): Token returned by the previous ListSubscriptions request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.subscription.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.subscription.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="list_subscriptions",
        op_kwargs={"NextToken": next_token},
    )
