"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, topic_arn: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a NextToken is also returned. Use the NextToken parameter in a new ListSubscriptionsByTopic call to get further results. This action is throttled at 30 transactions per second (TPS).

    Args:
        topic_arn(str): The ARN of the topic for which you wish to find subscriptions.
        next_token(str, optional): Token returned by the previous ListSubscriptionsByTopic request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.subscription.by_topic.list(ctx, topic_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.subscription.by_topic.list topic_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="list_subscriptions_by_topic",
        op_kwargs={"TopicArn": topic_arn, "NextToken": next_token},
    )
