"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get_all(hub, ctx, subscription_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns all of the properties of a subscription.

    Args:
        subscription_arn(str): The ARN of the subscription whose properties you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.subscription.attribute.get_all(ctx, subscription_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.subscription.attribute.get_all subscription_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="get_subscription_attributes",
        op_kwargs={"SubscriptionArn": subscription_arn},
    )


async def set_(
    hub, ctx, subscription_arn: str, attribute_name: str, attribute_value: str = None
) -> None:
    r"""
    **Autogenerated function**

    Allows a subscription owner to set an attribute of the subscription to a new value.

    Args:
        subscription_arn(str): The ARN of the subscription to modify.
        attribute_name(str): A map of attributes with their corresponding values. The following lists the names, descriptions, and values of the special request parameters that this action uses:    DeliveryPolicy – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.    FilterPolicy – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.    RawMessageDelivery – When set to true, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.    RedrivePolicy – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.   The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:    SubscriptionRoleArn – The ARN of the IAM role that has the following:   Permission to write to the Kinesis Data Firehose delivery stream   Amazon SNS listed as a trusted entity   Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see Fanout to Kinesis Data Firehose delivery streams in the Amazon SNS Developer Guide.  .
        attribute_value(str, optional): The new value for the attribute in JSON format. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.subscription.attribute.set(
                ctx, subscription_arn=value, attribute_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.subscription.attribute.set subscription_arn=value, attribute_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="set_subscription_attributes",
        op_kwargs={
            "SubscriptionArn": subscription_arn,
            "AttributeName": attribute_name,
            "AttributeValue": attribute_value,
        },
    )
