"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, phone_number: str, language_code: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Adds a destination phone number to an account in the SMS sandbox and sends a one-time password (OTP) to that phone number. When you start using Amazon SNS to send SMS messages, your account is in the SMS sandbox. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see SMS sandbox in the Amazon SNS Developer Guide.

    Args:
        phone_number(str): The destination phone number to verify. On verification, Amazon SNS adds this phone number to the list of verified phone numbers that you can send SMS messages to.
        language_code(str, optional): The language to use for sending the OTP. The default value is en-US. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.sms.sandbox.phone_number.create(ctx, phone_number=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.sms.sandbox.phone_number.create phone_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="create_sms_sandbox_phone_number",
        op_kwargs={"PhoneNumber": phone_number, "LanguageCode": language_code},
    )


async def delete(hub, ctx, phone_number: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an account's verified or pending phone number from the SMS sandbox. When you start using Amazon SNS to send SMS messages, your account is in the SMS sandbox. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see SMS sandbox in the Amazon SNS Developer Guide.

    Args:
        phone_number(str): The destination phone number to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.sms.sandbox.phone_number.delete(ctx, phone_number=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.sms.sandbox.phone_number.delete phone_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="delete_sms_sandbox_phone_number",
        op_kwargs={"PhoneNumber": phone_number},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the calling account's current verified and pending destination phone numbers in the SMS sandbox. When you start using Amazon SNS to send SMS messages, your account is in the SMS sandbox. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see SMS sandbox in the Amazon SNS Developer Guide.

    Args:
        next_token(str, optional): Token that the previous ListSMSSandboxPhoneNumbersInput request returns. Defaults to None.
        max_results(int, optional): The maximum number of phone numbers to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.sms.sandbox.phone_number.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.sms.sandbox.phone_number.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="list_sms_sandbox_phone_numbers",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def verify(hub, ctx, phone_number: str, one_time_password: str) -> Dict:
    r"""
    **Autogenerated function**

    Verifies a destination phone number with a one-time password (OTP) for the calling account. When you start using Amazon SNS to send SMS messages, your account is in the SMS sandbox. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see SMS sandbox in the Amazon SNS Developer Guide.

    Args:
        phone_number(str): The destination phone number to verify.
        one_time_password(str): The OTP sent to the destination number from the CreateSMSSandBoxPhoneNumber call.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.sms.sandbox.phone_number.verify(
                ctx, phone_number=value, one_time_password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.sms.sandbox.phone_number.verify phone_number=value, one_time_password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="verify_sms_sandbox_phone_number",
        op_kwargs={"PhoneNumber": phone_number, "OneTimePassword": one_time_password},
    )
