"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the SMS sandbox status for the calling account in the target Region. When you start using Amazon SNS to send SMS messages, your account is in the SMS sandbox. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see SMS sandbox in the Amazon SNS Developer Guide.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.sms.sandbox.account_status.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.sms.sandbox.account_status.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="get_sms_sandbox_account_status",
        op_kwargs={},
    )
