"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    platform_application_arn: str,
    token: str,
    custom_user_data: str = None,
    attributes: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. CreatePlatformEndpoint requires the PlatformApplicationArn that is returned from CreatePlatformApplication. You can use the returned EndpointArn to send a message to a mobile app or by the Subscribe action for subscription to a topic. The CreatePlatformEndpoint action is idempotent, so if the requester already owns an endpoint with the same device token and attributes, that endpoint's ARN is returned without creating a new endpoint. For more information, see Using Amazon SNS Mobile Push Notifications.  When using CreatePlatformEndpoint with Baidu, two attributes must be provided: ChannelId and UserId. The token field must also contain the ChannelId. For more information, see Creating an Amazon SNS Endpoint for Baidu.

    Args:
        platform_application_arn(str): PlatformApplicationArn returned from CreatePlatformApplication is used to create a an endpoint.
        token(str): Unique identifier created by the notification service for an app on a device. The specific name for Token will vary, depending on which notification service is being used. For example, when using APNS as the notification service, you need the device token. Alternatively, when using GCM (Firebase Cloud Messaging) or ADM, the device token equivalent is called the registration ID.
        custom_user_data(str, optional): Arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB. Defaults to None.
        attributes(Dict, optional): For a list of attributes, see SetEndpointAttributes. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.platform.endpoint.create(
                ctx, platform_application_arn=value, token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.platform.endpoint.create platform_application_arn=value, token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="create_platform_endpoint",
        op_kwargs={
            "PlatformApplicationArn": platform_application_arn,
            "Token": token,
            "CustomUserData": custom_user_data,
            "Attributes": attributes,
        },
    )
