"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, platform: str, attributes: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging), to which devices and mobile apps may register. You must specify PlatformPrincipal and PlatformCredential attributes when using the CreatePlatformApplication action.  PlatformPrincipal and PlatformCredential are received from the notification service.   For ADM, PlatformPrincipal is client id and PlatformCredential is client secret.   For Baidu, PlatformPrincipal is API key and PlatformCredential is secret key.   For APNS and APNS_SANDBOX, PlatformPrincipal is SSL certificate and PlatformCredential is private key.   For GCM (Firebase Cloud Messaging), there is no PlatformPrincipal and the PlatformCredential is API key.   For MPNS, PlatformPrincipal is TLS certificate and PlatformCredential is private key.   For WNS, PlatformPrincipal is Package Security Identifier and PlatformCredential is secret key.   You can use the returned PlatformApplicationArn as an attribute for the CreatePlatformEndpoint action.

    Args:
        name(str): Application names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, hyphens, and periods, and must be between 1 and 256 characters long.
        platform(str): The following platforms are supported: ADM (Amazon Device Messaging), APNS (Apple Push Notification Service), APNS_SANDBOX, and GCM (Firebase Cloud Messaging).
        attributes(Dict): For a list of attributes, see SetPlatformApplicationAttributes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.platform.application.init.create(
                ctx, name=value, platform=value, attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.platform.application.init.create name=value, platform=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="create_platform_application",
        op_kwargs={"Name": name, "Platform": platform, "Attributes": attributes},
    )


async def delete(hub, ctx, platform_application_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see Using Amazon SNS Mobile Push Notifications.

    Args:
        platform_application_arn(str): PlatformApplicationArn of platform application object to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.platform.application.init.delete(
                ctx, platform_application_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.platform.application.init.delete platform_application_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="delete_platform_application",
        op_kwargs={"PlatformApplicationArn": platform_application_arn},
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the platform application objects for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). The results for ListPlatformApplications are paginated and return a limited list of applications, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call ListPlatformApplications using the NextToken string received from the previous call. When there are no more records to return, NextToken will be null. For more information, see Using Amazon SNS Mobile Push Notifications.  This action is throttled at 15 transactions per second (TPS).

    Args:
        next_token(str, optional): NextToken string is used when calling ListPlatformApplications action to retrieve additional records that are available after the first page results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.platform.application.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.platform.application.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="list_platform_applications",
        op_kwargs={"NextToken": next_token},
    )
