"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get_all(hub, ctx, platform_application_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see Using Amazon SNS Mobile Push Notifications.

    Args:
        platform_application_arn(str): PlatformApplicationArn for GetPlatformApplicationAttributesInput.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.platform.application.attribute.get_all(
                ctx, platform_application_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.platform.application.attribute.get_all platform_application_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="get_platform_application_attributes",
        op_kwargs={"PlatformApplicationArn": platform_application_arn},
    )


async def set_(hub, ctx, platform_application_arn: str, attributes: Dict) -> None:
    r"""
    **Autogenerated function**

    Sets the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see Using Amazon SNS Mobile Push Notifications. For information on configuring attributes for message delivery status, see Using Amazon SNS Application Attributes for Message Delivery Status.

    Args:
        platform_application_arn(str): PlatformApplicationArn for SetPlatformApplicationAttributes action.
        attributes(Dict): A map of the platform application attributes. Attributes in this map include the following:    PlatformCredential – The credential received from the notification service. For APNS and APNS_SANDBOX, PlatformCredential is private key. For GCM (Firebase Cloud Messaging), PlatformCredential is API key. For ADM, PlatformCredential is client secret.    PlatformPrincipal – The principal received from the notification service. For APNS and APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM (Firebase Cloud Messaging), there is no PlatformPrincipal. For ADM, PlatformPrincipal is client id.    EventEndpointCreated – Topic ARN to which EndpointCreated event notifications are sent.    EventEndpointDeleted – Topic ARN to which EndpointDeleted event notifications are sent.    EventEndpointUpdated – Topic ARN to which EndpointUpdate event notifications are sent.    EventDeliveryFailure – Topic ARN to which DeliveryFailure event notifications are sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.    SuccessFeedbackRoleArn – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.    FailureFeedbackRoleArn – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.    SuccessFeedbackSampleRate – Sample rate percentage (0-100) of successfully delivered messages.  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.platform.application.attribute.set(
                ctx, platform_application_arn=value, attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.platform.application.attribute.set platform_application_arn=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="set_platform_application_attributes",
        op_kwargs={
            "PlatformApplicationArn": platform_application_arn,
            "Attributes": attributes,
        },
    )
