"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them. The results for ListPhoneNumbersOptedOut are paginated, and each page returns up to 100 phone numbers. If additional phone numbers are available after the first page of results, then a NextToken string will be returned. To receive the next page, you call ListPhoneNumbersOptedOut again using the NextToken string received from the previous call. When there are no more records to return, NextToken will be null.

    Args:
        next_token(str, optional): A NextToken string is used when you call the ListPhoneNumbersOptedOut action to retrieve additional records that are available after the first page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.phone_number_opted_out.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.phone_number_opted_out.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="list_phone_numbers_opted_out",
        op_kwargs={"nextToken": next_token},
    )
