"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def add(
    hub, ctx, topic_arn: str, label: str, aws_account_id: List, action_name: List
) -> None:
    r"""
    **Autogenerated function**

    Adds a statement to a topic's access control policy, granting access for the specified accounts to the specified actions.

    Args:
        topic_arn(str): The ARN of the topic whose access control policy you wish to modify.
        label(str): A unique identifier for the new policy statement.
        aws_account_id(List): The account IDs of the users (principals) who will be given access to the specified actions. The users must have account, but do not need to be signed up for this service.
        action_name(List): The action you want to allow for the specified principal(s). Valid values: Any Amazon SNS action name, for example Publish.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.permission.add(
                ctx, topic_arn=value, label=value, aws_account_id=value, action_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.permission.add topic_arn=value, label=value, aws_account_id=value, action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="add_permission",
        op_kwargs={
            "TopicArn": topic_arn,
            "Label": label,
            "AWSAccountId": aws_account_id,
            "ActionName": action_name,
        },
    )


async def remove(hub, ctx, topic_arn: str, label: str) -> None:
    r"""
    **Autogenerated function**

    Removes a statement from a topic's access control policy.

    Args:
        topic_arn(str): The ARN of the topic whose access control policy you wish to modify.
        label(str): The unique label of the statement you want to remove.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.permission.remove(ctx, topic_arn=value, label=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.permission.remove topic_arn=value, label=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="remove_permission",
        op_kwargs={"TopicArn": topic_arn, "Label": label},
    )
