"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the calling account's dedicated origination numbers and their metadata. For more information about origination numbers, see Origination numbers in the Amazon SNS Developer Guide.

    Args:
        next_token(str, optional): Token that the previous ListOriginationNumbers request returns. Defaults to None.
        max_results(int, optional): The maximum number of origination numbers to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.origination_number.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.origination_number.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="list_origination_numbers",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
