"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def opt(hub, ctx, phone_number: str) -> Dict:
    r"""
    **Autogenerated function**

    Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to the number. You can opt in a phone number only once every 30 days.

    Args:
        phone_number(str): The phone number to opt in. Use E.164 format.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.in_phone_number.opt(ctx, phone_number=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.in_phone_number.opt phone_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="opt_in_phone_number",
        op_kwargs={"phoneNumber": phone_number},
    )
