"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def check(hub, ctx, phone_number: str) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your account. You cannot send SMS messages to a number that is opted out. To resume sending messages, you can opt in the number by using the OptInPhoneNumber action.

    Args:
        phone_number(str): The phone number for which you want to check the opt out status.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.if_phone_number_is_opted_out.check(ctx, phone_number=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.if_phone_number_is_opted_out.check phone_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="check_if_phone_number_is_opted_out",
        op_kwargs={"phoneNumber": phone_number},
    )
