"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(hub, ctx, endpoint_arn: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more information, see Using Amazon SNS Mobile Push Notifications.  When you delete an endpoint that is also subscribed to a topic, then you must also unsubscribe the endpoint from the topic.

    Args:
        endpoint_arn(str): EndpointArn of endpoint to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.endpoint.init.delete(ctx, endpoint_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.endpoint.init.delete endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="delete_endpoint",
        op_kwargs={"EndpointArn": endpoint_arn},
    )
