"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get_all(hub, ctx, endpoint_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see Using Amazon SNS Mobile Push Notifications.

    Args:
        endpoint_arn(str): EndpointArn for GetEndpointAttributes input.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.endpoint.attribute.get_all(ctx, endpoint_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.endpoint.attribute.get_all endpoint_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="get_endpoint_attributes",
        op_kwargs={"EndpointArn": endpoint_arn},
    )


async def set_(hub, ctx, endpoint_arn: str, attributes: Dict) -> None:
    r"""
    **Autogenerated function**

    Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see Using Amazon SNS Mobile Push Notifications.

    Args:
        endpoint_arn(str): EndpointArn used for SetEndpointAttributes action.
        attributes(Dict): A map of the endpoint attributes. Attributes in this map include the following:    CustomUserData – arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.    Enabled – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true, typically after updating Token.    Token – device token, also referred to as a registration id, for an app and mobile device. This is returned from the notification service when an app and mobile device are registered with the notification service.  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sns.endpoint.attribute.set(
                ctx, endpoint_arn=value, attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sns.endpoint.attribute.set endpoint_arn=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sns",
        operation="set_endpoint_attributes",
        op_kwargs={"EndpointArn": endpoint_arn, "Attributes": attributes},
    )
