"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns an Amazon S3 presigned URL for an update file associated with a specified JobId.

    Args:
        job_id(str): The ID for a job that you want to get the software update file for, for example JID123e4567-e89b-12d3-a456-426655440000.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.software_update.get_all(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.software_update.get_all job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="get_software_updates",
        op_kwargs={"JobId": job_id},
    )
