"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def create(
    hub,
    ctx,
    long_term_pricing_type: str,
    is_long_term_pricing_auto_renew: bool = None,
    snowball_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a job with the long-term usage option for a device. The long-term usage is a 1-year or 3-year long-term pricing type for the device. You are billed upfront, and AWS provides discounts for long-term pricing.

    Args:
        long_term_pricing_type(str): The type of long-term pricing option you want for the device, either 1-year or 3-year long-term pricing.
        is_long_term_pricing_auto_renew(bool, optional): Specifies whether the current long-term pricing type for the device should be renewed. Defaults to None.
        snowball_type(str, optional): The type of AWS Snow Family device to use for the long-term pricing job. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.long_term_pricing.create(
                ctx, long_term_pricing_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.long_term_pricing.create long_term_pricing_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="create_long_term_pricing",
        op_kwargs={
            "LongTermPricingType": long_term_pricing_type,
            "IsLongTermPricingAutoRenew": is_long_term_pricing_auto_renew,
            "SnowballType": snowball_type,
        },
    )


async def list_(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all long-term pricing types.

    Args:
        max_results(int, optional): The maximum number of ListLongTermPricing objects to return. Defaults to None.
        next_token(str, optional): Because HTTP requests are stateless, this is the starting point for your next list of ListLongTermPricing to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.long_term_pricing.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.long_term_pricing.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="list_long_term_pricing",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    long_term_pricing_id: str,
    replacement_job: str = None,
    is_long_term_pricing_auto_renew: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the long-term pricing type.

    Args:
        long_term_pricing_id(str): The ID of the long-term pricing type for the device.
        replacement_job(str, optional): Specifies that a device that is ordered with long-term pricing should be replaced with a new device. Defaults to None.
        is_long_term_pricing_auto_renew(bool, optional): If set to true, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.snowball.long_term_pricing.update(
                ctx, long_term_pricing_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.snowball.long_term_pricing.update long_term_pricing_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="snowball",
        operation="update_long_term_pricing",
        op_kwargs={
            "LongTermPricingId": long_term_pricing_id,
            "ReplacementJob": replacement_job,
            "IsLongTermPricingAutoRenew": is_long_term_pricing_auto_renew,
        },
    )
